*****************************************
*** TAXES AND CONTRIBUTIONS ON LABOUR ***
*****************************************
cd "Z:\work\Baze\SILC_Serbia\2019"
use income, clear

******************
*** EMPLOYEES ***
*****************
* taxes 
gen tx_ee = (yee_g_m - 15300)*0.1
replace tx_ee = 0 if yee_g_m<15300
label var tx_ee "Personal income tax employees"

* contributions  - pensions 
gen 	con_pen_ee = 23921*0.26 ///
				 if yee_g_m<23921
replace con_pen_ee = yee_g_m*0.26 ///
			     if yee_g_m>=23921 & yee_g_m<341725
replace con_pen_ee = 341725*0.26 ///
				 if yee_g_m>=341725 & yee_g_m!=.
label var con_pen_ee "Pension Contributions employees"

* contributions  - health insurance
gen 	con_hea_ee = 23921*0.103 ///
				 if yee_g_m<23921
replace con_hea_ee = yee_g_m*0.103 ///
			     if yee_g_m>=23921 & yee_g_m<341725
replace con_hea_ee = 341725*0.103 ///
				 if yee_g_m>=341725 & yee_g_m!=.
label var con_hea_ee "Health Contributions - employees"

* contributions  - unemployment insurance
gen 	con_une_ee = 23921*0.0075 ///
				 if yee_g_m<23921
replace con_une_ee = yee_g_m*0.0075 ///
			     if yee_g_m>=23921 & yee_g_m<341725
replace con_une_ee = 341725*0.0075 ///
				 if yee_g_m>=341725 & yee_g_m!=.
label var con_une_ee "Unemployment Contributions - employees"

* total contributions
egen con_ssc_ee = rowtotal(con_*_ee)
recode con_ssc_ee (0=.)
label var con_ssc_ee "Total Contributions - employees"

sum yee_n_m yee_g_m yee_g2_m tx_ee ///
	con_pen_ee con_hea_ee con_une_ee con_ssc_ee
	
gen yee_n_m_sim = yee_g2_m - tx_ee - con_ssc_ee	
 
sum yee_n_m yee_n_m_sim
la var yee_n_m_sim "Simulated net monthly wages"

* check
gen dif = yee_n_m_sim - yee_n_m
replace dif = int(dif)
tab dif // should be zero
drop dif 

* yearly incomes
gen yee_n_sim = yee_n_m_sim*tot_mont
la var yee_n_sim "Simulated net yearly wages"

bys idhh: egen yee_n_hh_sim = sum(yee_n_sim)
la var yee_n_hh_sim "Simulated net yearly wages"

duplicates drop idhh, force
keep idhh yee_n_hh_sim
save tax_sim, replace 


